// Coordinates (e.g. of a pixel)
public class Coordinates {
  public int x;  // horizontal coordinate
  public int y;  // vertical coordinate

  // Constructor: point (px, py)
  public Coordinates(int px, int py) {
    x= px; y= py;
  }
}

// ********************************

// A circle with a center and a radius
public class Circle {
  public Coordinates cent; // Center of circle
  private int rad;         // Radius of circle

  // Constructor: circle with center (x,y) and
  // radius r (>=0)
  public Circle (int x, int y, int r) {
    cent= new Coordinates(x,y);
    setRadius(r);
  }
  
  // Set radius to max of r and 0
  public void setRadius (int r) {
     if (r >= 0) rad= r; 
     else rad= 0;
  }

  // = radius of this circle
  public int radius () {
     return rad;
  }

  // = diameter of this circle
  public int diameter() {
    return 2*radius();
  }
    
  // = area of this circle
  public float area() {
    return (float) (Math.PI * radius() * radius());
  }
}
